/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Expertise
extends AbstractCard {
    public static final String ID = "Expertise";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Expertise");
    public static final String NAME = Expertise.cardStrings.NAME;
    public static final String DESCRIPTION = Expertise.cardStrings.DESCRIPTION;
    private static final int COST = 2;
    private static final int BLOCK_AMOUNT = 12;
    private static final int POOL = 2;

    public Expertise() {
        this(0);
    }

    public Expertise(int upgrades) {
        super(ID, NAME, "green/skill/expertise", "green/skill/expertise", 2, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.SELF, 2);
        this.baseBlock = 12;
        this.timesUpgraded = upgrades;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new GainBlockAction(p, p, this.block));
    }

    @Override
    public AbstractCard makeCopy() {
        return new Expertise(this.timesUpgraded);
    }

    @Override
    public void upgrade() {
        this.upgradeBlock(4 + this.timesUpgraded);
        ++this.timesUpgraded;
        this.upgraded = true;
        this.name = NAME + "+" + this.timesUpgraded;
        this.initializeTitle();
    }

    @Override
    public boolean canUpgrade() {
        return true;
    }
}

